<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Login extends Controller_Template {

	public $template = 'v_login';

	public function action_index(){
		if(Auth::instance()->logged_in())
			HTTP::redirect('/');

		if(isset($_POST['btn'])){
			$remember = false;
			if(isset($_POST['remember'])){
				$remember = true;
			}
			if(Auth::instance()->login($_POST['user'], $_POST['password'], $remember)) {
                $continue = Arr::get($_POST, 'continue');
                if ($continue && preg_match('/^' . preg_quote('https://' . $_SERVER['HTTP_HOST'] . '/', '/') . 'logpost\/(more|more_ex)\//', $continue)) {
                    HTTP::redirect($continue);
                } else {
                    HTTP::redirect('/');
                }
            }
		}
	}

	public function action_logout(){
		$auth = Auth::instance();

		if($auth->logged_in())
			$auth->logout();
		HTTP::redirect('/');
	}
}